/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import io.github.cottonmc.cotton.gui.client.LibGui;
import io.github.cottonmc.cotton.gui.client.NinePatchBackgroundPainter;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.WItemSlot;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import java.util.function.Consumer;
import juuxel.libninepatch.NinePatch;
import juuxel.libninepatch.TextureRegion;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

@FunctionalInterface
public interface BackgroundPainter {
    public static final BackgroundPainter VANILLA = BackgroundPainter.createLightDarkVariants(BackgroundPainter.createNinePatch(new class_2960("libgui", "textures/widget/panel_light.png")), BackgroundPainter.createNinePatch(new class_2960("libgui", "textures/widget/panel_dark.png")));
    public static final BackgroundPainter SLOT = (matrices, left, top, panel) -> {
        if (!(panel instanceof WItemSlot)) {
            ScreenDrawing.drawBeveledPanel(matrices, left - 1, top - 1, panel.getWidth() + 2, panel.getHeight() + 2, -1207959552, 0x4C000000, -1191182337);
        } else {
            WItemSlot slot = (WItemSlot)panel;
            for (int x = 0; x < slot.getWidth() / 18; ++x) {
                for (int y = 0; y < slot.getHeight() / 18; ++y) {
                    int sy;
                    int sx;
                    int index = x + y * (slot.getWidth() / 18);
                    int lo = -1207959552;
                    int bg = 0x4C000000;
                    int hi = -1191182337;
                    if (slot.isBigSlot()) {
                        ScreenDrawing.drawBeveledPanel(matrices, x * 18 + left - 4, y * 18 + top - 4, 26, 26, lo, bg, hi);
                        if (slot.getFocusedSlot() != index) continue;
                        sx = x * 18 + left - 4;
                        sy = y * 18 + top - 4;
                        ScreenDrawing.coloredRect(matrices, sx, sy, 26, 1, -96);
                        ScreenDrawing.coloredRect(matrices, sx, sy + 1, 1, 25, -96);
                        ScreenDrawing.coloredRect(matrices, sx + 26 - 1, sy + 1, 1, 25, -96);
                        ScreenDrawing.coloredRect(matrices, sx + 1, sy + 26 - 1, 25, 1, -96);
                        continue;
                    }
                    ScreenDrawing.drawBeveledPanel(matrices, x * 18 + left, y * 18 + top, 18, 18, lo, bg, hi);
                    if (slot.getFocusedSlot() != index) continue;
                    sx = x * 18 + left;
                    sy = y * 18 + top;
                    ScreenDrawing.coloredRect(matrices, sx, sy, 18, 1, -96);
                    ScreenDrawing.coloredRect(matrices, sx, sy + 1, 1, 17, -96);
                    ScreenDrawing.coloredRect(matrices, sx + 18 - 1, sy + 1, 1, 17, -96);
                    ScreenDrawing.coloredRect(matrices, sx + 1, sy + 18 - 1, 17, 1, -96);
                }
            }
        }
    };

    public void paintBackground(class_4587 var1, int var2, int var3, WWidget var4);

    public static BackgroundPainter createColorful(int panelColor) {
        return (matrices, left, top, panel) -> ScreenDrawing.drawGuiPanel(matrices, left, top, panel.getWidth(), panel.getHeight(), panelColor);
    }

    public static BackgroundPainter createColorful(int panelColor, float contrast) {
        return (matrices, left, top, panel) -> {
            int shadowColor = ScreenDrawing.multiplyColor(panelColor, 1.0f - contrast);
            int hilightColor = ScreenDrawing.multiplyColor(panelColor, 1.0f + contrast);
            ScreenDrawing.drawGuiPanel(matrices, left, top, panel.getWidth(), panel.getHeight(), shadowColor, panelColor, hilightColor, -16777216);
        };
    }

    public static NinePatchBackgroundPainter createNinePatch(class_2960 texture) {
        return BackgroundPainter.createNinePatch(new Texture(texture), builder -> builder.cornerSize(4).cornerUv(0.25f));
    }

    public static NinePatchBackgroundPainter createNinePatch(Texture texture, Consumer<NinePatch.Builder<class_2960>> configurator) {
        TextureRegion region = new TextureRegion((Object)texture.image(), texture.u1(), texture.v1(), texture.u2(), texture.v2());
        NinePatch.Builder builder = NinePatch.builder((TextureRegion)region);
        configurator.accept((NinePatch.Builder<class_2960>)builder);
        return new NinePatchBackgroundPainter((NinePatch<class_2960>)builder.build());
    }

    public static BackgroundPainter createLightDarkVariants(BackgroundPainter light, BackgroundPainter dark) {
        return (matrices, left, top, panel) -> {
            if (LibGui.isDarkMode()) {
                dark.paintBackground(matrices, left, top, panel);
            } else {
                light.paintBackground(matrices, left, top, panel);
            }
        };
    }
}

